//+------------------------------------------------------------------+
//|                                        Multi pair Stochastic.mq4 |
//|                                                           mladen |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      "mladenfx@gmail.com"

#property indicator_separate_window
#property  indicator_buffers 4
#property indicator_minimum  0
#property indicator_maximum  100
#property  indicator_color1  Orange
#property  indicator_color2  Red
#property  indicator_color3  DimGray
#property  indicator_color4  DimGray
#property  indicator_style2  STYLE_DOT
#property  indicator_style3  STYLE_DOT
#property  indicator_style4  STYLE_DOT

//
//
//
//
//

extern string    pairs          = "EURUSD;GBPUSD;USDCAD";
extern int       barsPerPair    = 70;
extern string    stochastic     = "parameters";
extern int       KPeriod        = 14;
extern int       DPeriod        =  3;
extern int       Slowing        =  3;
extern int       PriceField     =  0;
extern int       levelUp        = 80;
extern int       levelDown      = 20;
extern string    text           = "color";
extern color     textColor      = Silver;
extern color     backColor      = C'48,48,48';
extern int       separatorWidth = 6;

//
//
//
//
//

double   ind_buffer1[];
double   ind_buffer2[];
double   ind_buffer3[];
double   ind_buffer4[];

//
//
//
//
//

string   aPairs[];
string   shortName;
int      window;  



//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//

int init()
{
   SetIndexBuffer(0,ind_buffer1);
   SetIndexBuffer(1,ind_buffer2);
   SetIndexBuffer(2,ind_buffer3);
   SetIndexBuffer(3,ind_buffer4);
   SetIndexLabel(2,NULL);
   SetIndexLabel(3,NULL);

   //
   //
   //
   //
   //

      pairs = StringUpperCase(StringTrimLeft(StringTrimRight(pairs)));
      if (StringSubstr(pairs,StringLen(pairs),1) != ";")
                       pairs = StringConcatenate(pairs,";");

         //
         //
         //
         //
         //                                   
            
         int s =  0;
         int i =  StringFind(pairs,";",s);
         string current;
         string temp;
            while (i > 0)
            {
               if (IsMini())
                     current = StringSubstr(pairs,s,i-s)+"m";
               else  current = StringSubstr(pairs,s,i-s);
               if (iClose(current,0,0) > 0)
                  {
                     ArrayResize(aPairs,ArraySize(aPairs)+1);
                                 aPairs[ArraySize(aPairs)-1] = current;
                                 if (current == Symbol())
                                 {
                                       temp      = aPairs[0];
                                       aPairs[0] = current;
                                       aPairs[ArraySize(aPairs)-1] = temp;
                                 }                                       
                  }
                  s = i + 1;
                  i = StringFind(pairs,";",s);
            }

   //
   //
   //
   //
   //
 
      separatorWidth = MathMax(separatorWidth,4);
      shortName = MakeUniqueName("Multi Stochastic "," ("+KPeriod+","+DPeriod+","+Slowing+")");
      IndicatorShortName(shortName);
 
   //
   //
   //
   //
   //
   
   return(0);
}

int deinit()
{
   for (int i = 0; i < ArraySize(aPairs); i++) { 
         ObjectDelete(shortName+i);
         ObjectDelete(shortName+i+i);
      }         
   return(0);
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int    limit = ArraySize(aPairs);
   int    i,k;
   
         window = WindowFind(shortName);  
         k = 0; for (i=0; i<limit; i++) k = calculateStoch(aPairs[i],barsPerPair,k,i);

   //
   //
   //
   //
   //

   for (i=0;i<6;i++) SetIndexDrawBegin(i,Bars-k);
   return(0);
}


//+------------------------------------------------------------------+
//+                                                                  +
//+------------------------------------------------------------------+

bool isSignalCrossing(int shift)
{
   double res = (ind_buffer1[shift]   - ind_buffer2[shift])*
                (ind_buffer1[shift+1] - ind_buffer2[shift+1]); 
   return(res<=0);
}

//+------------------------------------------------------------------+
//+                                                                  +
//+------------------------------------------------------------------+

int calculateStoch(string symbol,int limit,int shift,int element)
{
   int i;
 
   //
   //
   //
   //
   //

   for(i=0; i<limit; i++) {
      ind_buffer1[shift+i]=iStochastic(symbol,0,KPeriod,DPeriod,Slowing,PriceField,0,0,i);
      ind_buffer2[shift+i]=iStochastic(symbol,0,KPeriod,DPeriod,Slowing,PriceField,0,1,i);
      ind_buffer3[shift+i]=levelUp;
      ind_buffer4[shift+i]=levelDown;
   }            

   
   //
   //
   //
   //
   //

   for (i=0;i<separatorWidth;i++) {
         ind_buffer1[shift+limit+i] = EMPTY_VALUE;                     
         ind_buffer2[shift+limit+i] = EMPTY_VALUE;                     
         ind_buffer3[shift+limit+i] = EMPTY_VALUE;                     
         ind_buffer4[shift+limit+i] = EMPTY_VALUE;                     
      }         

   //
   //
   //
   //
   //
   
   createLabel(symbol,element,shift+limit+separatorWidth-2,isSignalCrossing(shift));
   return(shift+limit+separatorWidth-1);
}



//+------------------------------------------------------------------+
//+                                                                  +
//+------------------------------------------------------------------+
//
//
//
//
//

void createLabel(string symbol,int element, int shift, bool signalCrossing)
{
   string name   = shortName+element;
   double price1 = 100;
   double price2 =   0;
   
   //
   //
   //
   //
   //
   
   if (ObjectFind(name) == -1)
      {
         ObjectCreate(name,OBJ_TEXT,window,0,0);
         ObjectSet(name,OBJPROP_ANGLE,90);
         ObjectSetText(name,symbol);
      }
      ObjectSet(name,OBJPROP_TIME1 ,Time[shift]);
      ObjectSet(name,OBJPROP_PRICE1,(price1+price2)/2);
      if (signalCrossing)
           ObjectSet(name,OBJPROP_COLOR,Gold);
      else ObjectSet(name,OBJPROP_COLOR,textColor);

   //
   //
   //
   //
   //

 
   name = shortName+element+element;
   if (ObjectFind(name) == -1)
      {
         ObjectCreate(name,OBJ_RECTANGLE,window,0,0,0,0);
         ObjectSet(name,OBJPROP_COLOR,backColor);
      }         
      ObjectSet(name,OBJPROP_TIME1,Time[shift]);
      ObjectSet(name,OBJPROP_PRICE1,price1);
      ObjectSet(name,OBJPROP_TIME2,Time[shift-(separatorWidth-2)]);
      ObjectSet(name,OBJPROP_PRICE2,price2);
}

//+------------------------------------------------------------------+
//+                                                                  +
//+------------------------------------------------------------------+
//
//
//
//
//


string StringUpperCase(string str)
{
   string   s = str;
   int      lenght = StringLen(str) - 1;
   int      char;
   
   while(lenght >= 0)
      {
         char = StringGetChar(s, lenght);
         
         //
         //
         //
         //
         //
         
         if((char > 96 && char < 123) || (char > 223 && char < 256))
                  s = StringSetChar(s, lenght, char - 32);
          else 
              if(char > -33 && char < 0)
                  s = StringSetChar(s, lenght, char + 224);
                  
         //
         //
         //
         //
         //
                                 
         lenght--;
   }
   
   //
   //
   //
   //
   //
   
   return(s);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

string MakeUniqueName(string first, string rest)
{
   string result = first+(MathRand()%1001)+rest;

   while (WindowFind(result)> 0)
          result = first+(MathRand()%1001)+rest;
   return(result);
}
bool IsMini()
{
   if (StringFind(Symbol(),"m") > -1)
         return(true);
   else  return(false);    
}